CREATE OR REPLACE FUNCTION CREATETABLE() 
RETURNS VOID AS 
$BODY$ 
DECLARE
    MSGFINAL TEXT := 'FOI CRIADA';
BEGIN 
    IF NOT EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS WHERE lower(TABLE_NAME) = 'est_prod_preco_propz_identificado') THEN 
        CREATE TABLE EST_PROD_PRECO_PROPZ_IDENTIFICADO (
		    cd_emp int not null,
            cd_filial int not null ,
			cd_prod int not null,
            cd_tabloide int not null,
			valor_tabela numeric(14,4),
			vlr_oferta numeric(14,4),
			flag_sobrepoe_descontos int,
			dt_cad timestamp,
			dt_ult_alt timestamp,
			cd_usu int,
			dt_hr_carga date,
			CONSTRAINT est_prod_preco_propz_identificado_pkey PRIMARY KEY (cd_emp, cd_filial, cd_prod)
		)
		WITH (OIDS=FALSE);
    ELSE    
        MSGFINAL := 'A TABELA JÁ EXISTE';
    END IF;

    RAISE NOTICE 'TABELA EST_PROD_PRECO_PROPZ_IDENTIFICADO %', MSGFINAL::VARCHAR;

END; 
$BODY$ 
LANGUAGE PLPGSQL VOLATILE 
COST 100; 
ALTER FUNCTION CREATETABLE() OWNER TO POSTGRES;
SELECT CREATETABLE(); 
DROP FUNCTION CREATETABLE();

